//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "relatywstereo.h"
#include "fdroga.h"
#include <math.h>
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner) : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormShow(TObject *Sender)
{
 odczytaj_parametry();
}
//---------------------------------------------------------------------------
// Odczytaj parametry
void TForm1 :: odczytaj_parametry( void)
{
 try
 {
    sp = (StylPatrzenia)RadioGroup1 -> ItemIndex;
    if( sp == Anaglif)
    {
        Lkolor = clRed;
        Rkolor = clAqua;
    }
    else
    {
        Lkolor = Rkolor = clBlack;
    }
    baza = (double)TrackBar1 -> Position / 100.;
    obserwator.x = (double)TrackBar2 -> Position / 10.;
    obserwator.y = (double)TrackBar3 -> Position / 10.;
    obserwator.z = (double)TrackBar4 -> Position / 10.;
    ogniskowa = (double)TrackBar5 -> Position/100.;
    v = N_c * TrackBar6 -> Position / 300.;
 }
 catch(...)
 {
 }
}
//---------------------------------------------------------------------------
//  Wykrelenie kostki, rozpitej na podanych wierzchokach
void __fastcall TForm1::PaintBox1Paint(TObject *Sender)
{
 TRelatywStereo rs( obserwator, //pozycja obserwatora
    0, 0, PaintBox1 -> Width, PaintBox1 -> Height, //okienko ekranowe
    v,                          //prdko
    baza,                       //odlego midzy oczami
    PaintBox1 -> Canvas,        //aparat graficzny
    sp,                         //styl projekcji stereo
    ogniskowa);                 //odlego oka od paszczyzny obrazowej

 int il_podzial = 10;
 int i;
 double h = -10;                //poziom gruntu
                                //p1 ...p4 odpowiadaj za pas drogi
                                //p5 ...p8 odpowiadaj za lini rodkow
                                //p9 ...p10 - to przydrone supy
 TPunkt p1(0,-10,h), p2(0,10,h), p3(-5000,10,h), p4(-5000,-10,h);
 TPunkt p5(0,-0.2,h), p6(0,0.2,h), p7(0,0.2,h), p8(0,-0.2,h);
 TPunkt p9(0,-10,h), p10(0,-10,20);

 rs.czworokat_stereo( p1, p2, p3, p4, il_podzial, Lkolor, Rkolor);  //pas drogi

 for( i = 0; i < 20; i++)       //linie rodkowe
 {
    p5.x = p6.x = - i * 50;
    p7.x = p8.x = p5.x - 20;
    rs.czworokat_stereo( p5, p6, p7, p8, il_podzial, Lkolor, Rkolor);
 }

 for( i = 0; i > -5000; i-=50)  //supy co 50 metrw
 {
    p9.x = p10.x = i;
    p9.y = p10.y = -10.;        //lewa strona drogi
    rs.linia_stereo( p9, p10, il_podzial, Lkolor, Rkolor);

    p9.y = p10.y = 10.;         //prawa strona
    rs.linia_stereo( p9, p10, il_podzial, Lkolor, Rkolor);
 }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::TrackBar1Change(TObject *Sender)
{
 odczytaj_parametry();
 PaintBox1 -> Refresh();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormKeyPress(TObject *Sender, char &Key)
{
 if( Key == VK_ESCAPE)
    Close();
}
//---------------------------------------------------------------------------

